# Copyright (c) 2009 ActiveState Software Inc.
# See http://www.activestate.com/activepython/license/ for licensing
# information.

"""
    supported.py
    ~~~~~~~~~~~~
    
    Python versions and OS architectures supported by PyPM
    and the repository can be configured here.
"""

import logging

from pypm.common.log import NullHandler
logging.getLogger('platinfo').addHandler(NullHandler()) # sink it
import platinfo

# Workaround for http://code.google.com/p/platinfo/issues/detail?id=5
import warnings
warnings.filterwarnings("ignore", category=platinfo.LinuxDistroVersionWarning)

__all__ = ['py_versions', 'os_architectures']


class PyPMPlatInfo(platinfo.PlatInfo):
    """PyPM specific platform names"""

    def name(self):
        name = super(PyPMPlatInfo, self).name()
        if name.startswith('macosx'):
            # strip the arch part from mac platnames
            return 'macosx'
        else:
            return name

PLATINFO = PyPMPlatInfo() # Since platinfo runs expensive processes (g++),
                          # we cache the detected valuce once and forever.
                          # It is *your* responsibility to reuse this value
                          # instead of invoking `platinfo.platname` again.
PLATNAME = PLATINFO.name()


# 
# supported variations
#

py_versions = [
    "2.6",
    #"2.7",
    #"3.1"
]

os_architectures = [
    "win32-x86",
    "win64-x64",
    "linux-x86",
    "linux-x86_64",
    "macosx"
]

   
