# Copyright (c) 2009 ActiveState Software Inc.
# See http://www.activestate.com/activepython/license/ for licensing
# information.

"""
    pypm.common.errors
    ~~~~~~~~~~~~~~~~~~

    Custom exceptions thrown by PyPM
"""

class PyPMError(Exception):
    """Base class for all PyPM errors """

    def __str__(self):
        # return [$CLASS] [$msg or $docstring]
        msg = Exception.__str__(self) or self.__class__.__doc__
        return '[{0.__class__.__name__}] {1}'.format(
            self, Exception.__str__(self))

    
#
# Specific errors that arise during the build process
# 

class SetupPyBuildFailed(PyPMError):
    """setup.py build returned non-zero"""


# 
# package metadata related errors
#

class MetadataError(PyPMError): pass

class MetadataDetectionFailed(MetadataError):
    """No metadata could be detected in this package"""

class BadMetadata(MetadataError):
    """Programmer specified invalid metadata"""

class SetupPyMissing(MetadataError):
    """setup.py is missing in source"""
